*** COS 2018 11, last update 2022 09  
           
program define dq_fil_std, rclass  
syntax , $syntax_datasource_files $syntax_variablelists $syntax_analysissettings $syntax_reportformatting $syntax_debugging  
local indent=`indent'+5  
local adoname "dq_fil_std"  
local text_i "di as text _n "  					  
local filenumber=0							  
local selectedfiles ""						  
local reportstop=0							  
global studydatafilelist ""					  
local filetotalnumber= wordcount("`targetfiles'")  
local idtotalnumber= wordcount("`idvars'")  
if `filetotalnumber'>1 & "`idvars'"=="" {  
	di as error "Several files (`filetotalnumber') have been specified for use but no ID variable has been specified. The program will be ended."  
	di as text "  "  
	          
	*** DQ_process_decision: DQ_INTcall_5		- Critical  
	local reportstop=1  
	dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Critical_1") colcontent2("`filetotalnumber' $DQ_INT_critical_22") colcontent3($DQ_INTcall_critical_5)  indent(`indent')  
	di as error "Critical problem: No ID variable provided despite selecting more than one study data file. Please ad using 'idvars' option and run Qualityreporter again!"  
	di as text "  "  
}          
*Check for ID variables not in Problem variable reports HOTFIX  
if `filetotalnumber'==1 & `problemvarreport'==0 & "`idvars'"=="" {  
	`text_i' "No ID variable has been specified, impeding related integrity checks. Please add using 'idvars' option!"  
	*** DQ_process_decision: DQ_INTcall_5	- Warning  
	`text_i' "Insufficient programm call; Implementation form: No ID variable" _n(3)  
	dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Warning_1") colcontent2("$DQ_INT_critical_23") ///  
			 colcontent3($DQ_INTcall_issue_5)  indent(`indent')  
}          
			        
					      
tokenize `targetfiles'						  
while "`1'"~="" {  
	local file="`1'"  
	local filenumber=`filenumber'+1																		  
	capture sum _all  
	dq_fil_exc, cdir("`sd'") cfile(`file'.dta) filetype(Study data)  indent(`indent')  
	if `reportstop'==0 local reportstop 	"`r(reportstop)'"							  
	          
	global studydatafilelist "$studydatafilelist `file'"								  
	          
	if `reportstop'==0 {  
	          
		if `lowercase'==1 {  
			foreach var of varlist _all {  
				qui rename `var', lower  
			}       
		}        
		         
		capture drop __000*  
		if _rc==0 {  
			`text_i' "The data set contained illegible temporary like variables that have been deleted."  
		}        
		capture drop _merge  
		if _rc==0 {  
			`text_i' "The data set contained illegible merge variable. It has been deleted."  
		}		      
		         
		if "`idvars'"~=""  {  
		         
	          
			dq_hlp_dds1 , cleanstring("`idvars'") vartype(12)   indent(`indent')  
			local idvars = "`r(cleanstring)'"		  
			        
			dq_int_var1 , varchecklist(`idvars') tablename(integtable_studydata) row(integtablerows_studydata) breakreport(`breakreport') vartype(12)   indent(`indent')  
			local checked_idvars = "`r(varchecklist)'"  
			local idvarnumber = `r(varnumber)'  
			        
			if strtrim("`idvars'")~=strtrim("`checked_idvars'") {  
				       
				*** DQ_quality_decision: 	DQ_INT_4  
				return local reportstop=1	  
				di     
				di as error "Fatal problem: Specified ID variable not available."  
				di as text "  "  
				`text_i' "Requested: `idvars' ; observed: `checked_idvars'"  
				`text_i' "Please check and run Qualityreporter again."					  
				`text_i' "Data Quality Classification:  Indicator: Unexpected set of data elements ; Implementation form: Unavailable study data elements" _n  
				dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) ///  
					colcontent1("$Critical_1") colcontent2("Missing ID variables") ///  
					colcontent3(Indicator: Unexpected set of data elements ; Implementation form: Unavailable ID variable - Requested: `idvars' ; observed: `checked_idvars' - $idvarnonexist_critical_4)  indent(`indent')	  
			}       
			if "`idvars'"=="`checked_idvars'" {  
				qui egen id_unique=concat(`idvars')	, format(%40.0g)											  
				dq_int_dup1 , idvars(id_unique) targetfiles("`file'")  tablename(integtable_studydata) row(integtablerows_studydata)  breakreport(`breakreport') indent(`indent')	  
				local reportstop=`r(reportstop)'  
				capture save "`rd'\`file'_c_leaned.dta", replace													  
				if _rc>0 {  
					di as error "Fatal problem: Prepared data set `file'_c_leaned.dta could not be saved. Please check and rerun report."  
					di as text "  "  
					local reportstop=1  
				}      
			}       
		}        
	          
		capture confirm variable id_unique																	  
		if _rc>0 	{  
			qui gen id_unique=_n  
		}        
		         
		lab var id_unique "ID variable"  
		         
	}	        
		         
	macro shift																								  
}          
if `reportstop'==0 & `filetotalnumber'>1  {				  
	dq_fil_mrg, rd("`rd'") targetfiles("`targetfiles'") idvars(id_unique) filetype(Study data) breakreport(`breakreport')  indent(`indent')  
	local reportstop=`r(reportstop)'  
}          
foreach file of local targetfiles {  
	capture confirm file "`rd'\`file'_c_leaned.dta"	  
	if _rc==0 {			  
		capture noisily erase "`rd'\`file'_c_leaned.dta"  
		if _rc>0 di as error "Deletion of auxilary file `rd'\`file'_c_leaned.dta failed."  
	}         
}          
return local reportstop=`reportstop'		  
end        
